#ifndef OPENREADERDIALOG_H
#define OPENREADERDIALOG_H

#include <QDialog>
#include <ui_OpenReaderDialog.h>

#include <QrfeReaderManager>

class QTimer;
class QMenu;
class QAction;

class SerialPortSettingsDialog;

class OpenReaderDialog : public QDialog
{
    Q_OBJECT

public:
    OpenReaderDialog(QrfeReaderManager* manager, QWidget *parent = 0);
    ~OpenReaderDialog();

public slots:
    int exec();
	void tryAccept();

	void changeBaud();

	void currentTabChanged ( int index );

	void focusChanged ( QWidget * old, QWidget * now );

	void linkActivated ( const QString & link );

	void incrementProgress();

	void reloadDeviceLists();
	void reloadSerialList();
	void reloadIpCache();
	void reloadBonjourList();
	void reloadHidList();

	void storeIpInCache(QString ip);

	void ipSelected(QListWidgetItem * item);
	void showIpListPopup(const QPoint &p);
	void deleteIpListEntry();

protected:
	virtual void keyPressEvent ( QKeyEvent * event );

private:
	void startWait();
	void stopWait();

private:
    Ui::OpenReaderDialogClass ui;

    SerialPortSettingsDialog* 		m_serialPortSettingsDialog;

    QrfeReaderManager* 				m_manager;
    //QrfeReaderManager::SerialBaud	m_serialBaudrate;

	QWidget*				m_focusWidget;
	QTimer*					m_waitRunner;

	QMenu*					m_context;
	QAction*				m_context_delete;
	QString					m_ipListEntryToDelete;
};

#endif // OPENREADERDIALOG_H
